function tc = importTrqCoupling(dataFile)
    arguments
        dataFile string = []; 
    end

    if isempty(dataFile)
        [dataFile, path] = uigetfile({'*.xlsx;*.xls',...
            'Excel Spreadsheet (*.xlsx,*.xls)';
            '*.*',  'All Files (*.*)'}, ...
            'Select a File');
        dataFile = fullfile(path, dataFile);
    end
    [~, dataFileName] = fileparts(dataFile);

    % Read main parameters from the "main" sheet
    opts = detectImportOptions(dataFile,'Sheet','main', 'ReadRowNames',1);
    rawdata = readtable(dataFile, opts);
    
    tc.shortName = dataFileName;
    tc.mass = rawdata.value('mass'); % mass, kg
    tc.spdRatio = rawdata.value('Speed Ratio');
    
    % Read full name
    tmp = readcell(dataFile,'Sheet','main');
    [i,j] = find(strcmp(tmp,'Full Name'));
    tc.fullName = tmp(i,j+1);

end